%------------------------------------------------------------------------------
% File     : COM194^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Grammars and languages 1238
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : gram_lang__1238.p [Bla16]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.2.0, 0.25 v7.1.0
% Syntax   : Number of formulae    :  334 ( 135 unt;  62 typ;   0 def)
%            Number of atoms       :  677 ( 297 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 3834 (  73   ~;  19   |;  77   &;3394   @)
%                                         (   0 <=>; 271  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   7 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  224 ( 224   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   62 (  59 usr;   8 con; 0-6 aty)
%            Number of variables   :  989 (  51   ^; 856   !;  52   ?; 989   :)
%                                         (  30  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:47:54.192
%------------------------------------------------------------------------------
%----Could-be-implicit typings (7)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_Sum__Type_Osum,type,
    sum_sum: $tType > $tType > $tType ).

thf(ty_t_DTree_Odtree,type,
    dtree: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_DTree_OT,type,
    t: $tType ).

thf(ty_t_DTree_ON,type,
    n: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (55)
thf(sy_cl_Lattices_Obounded__lattice,type,
    bounded_lattice: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Obot,type,
    bot: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Otop,type,
    top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Lattices_Obounded__lattice__top,type,
    bounded_lattice_top: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_DTree_ONode,type,
    node: n > ( set @ ( sum_sum @ t @ dtree ) ) > dtree ).

thf(sy_c_DTree_Ocont,type,
    cont: dtree > ( set @ ( sum_sum @ t @ dtree ) ) ).

thf(sy_c_DTree_Odtree_Oroot,type,
    root: dtree > n ).

thf(sy_c_DTree_Ounfold,type,
    unfold: 
      !>[A: $tType] : ( ( A > n ) > ( A > ( set @ ( sum_sum @ t @ A ) ) ) > A > dtree ) ).

thf(sy_c_Fun_Ocomp,type,
    comp: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( B > C ) > ( A > B ) > A > C ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OFr,type,
    gram_L861583724lle_Fr: ( set @ n ) > dtree > ( set @ t ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OFrr,type,
    gram_L1556062726le_Frr: ( set @ n ) > dtree > ( set @ t ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OH,type,
    gram_L1451583624elle_H: dtree > n > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OH__c,type,
    gram_L1221482011le_H_c: dtree > n > ( set @ ( sum_sum @ t @ n ) ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OH__r,type,
    gram_L1221482026le_H_r: dtree > n > n ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OL,type,
    gram_L1451583628elle_L: ( set @ n ) > n > ( set @ ( set @ t ) ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OP,type,
    gram_L1451583632elle_P: set @ ( product_prod @ n @ ( set @ ( sum_sum @ t @ n ) ) ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Odeftr,type,
    gram_L1231612515_deftr: n > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Ohsubst,type,
    gram_L1004374585hsubst: dtree > dtree > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Ohsubst__c,type,
    gram_L1905609002ubst_c: dtree > dtree > ( set @ ( sum_sum @ t @ dtree ) ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Ohsubst__r,type,
    gram_L1905609017ubst_r: dtree > n ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFr,type,
    gram_L1333338417e_inFr: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFr2,type,
    gram_L805317441_inFr2: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFrr,type,
    gram_L805317505_inFrr: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinItr,type,
    gram_L830233218_inItr: ( set @ n ) > dtree > n > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Opick,type,
    gram_L315592705e_pick: dtree > n > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Orcut,type,
    gram_L1828378864e_rcut: dtree > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Oreg,type,
    gram_L1918716148le_reg: ( n > dtree ) > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Oregular,type,
    gram_L646766332egular: dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Osubtr,type,
    gram_L716654942_subtr: ( set @ n ) > dtree > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Osubtr2,type,
    gram_L1283001940subtr2: ( set @ n ) > dtree > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OsubtrOf,type,
    gram_L1614515765ubtrOf: dtree > n > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Owf,type,
    gram_L864798063lle_wf: dtree > $o ).

thf(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_Lattices_Osup__class_Osup,type,
    sup_sup: 
      !>[A: $tType] : ( A > A > A ) ).

thf(sy_c_Orderings_Obot__class_Obot,type,
    bot_bot: 
      !>[A: $tType] : A ).

thf(sy_c_Orderings_Otop__class_Otop,type,
    top_top: 
      !>[A: $tType] : A ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Ois__singleton,type,
    is_singleton: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Set_Ovimage,type,
    vimage: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( set @ B ) > ( set @ A ) ) ).

thf(sy_c_Sum__Type_OInl,type,
    sum_Inl: 
      !>[A: $tType,B: $tType] : ( A > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Sum__Type_OInr,type,
    sum_Inr: 
      !>[B: $tType,A: $tType] : ( B > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Sum__Type_Oold_Osum_Orec__sum,type,
    sum_rec_sum: 
      !>[A: $tType,T: $tType,B: $tType] : ( ( A > T ) > ( B > T ) > ( sum_sum @ A @ B ) > T ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_K____,type,
    k: n > ( set @ t ) ).

thf(sy_v_ftr____,type,
    ftr: n > dtree ).

thf(sy_v_n,type,
    n2: n ).

thf(sy_v_ns,type,
    ns: set @ n ).

thf(sy_v_tns____,type,
    tns: set @ ( sum_sum @ t @ n ) ).

thf(sy_v_tr_H____,type,
    tr: dtree ).

thf(sy_v_tr____,type,
    tr2: dtree ).

%----Relevant facts (256)
thf(fact_0_dtr,axiom,
    gram_L864798063lle_wf @ tr2 ).

% dtr
thf(fact_1_tr_H__def,axiom,
    ( tr
    = ( gram_L1004374585hsubst @ tr2 @ tr2 ) ) ).

% tr'_def
thf(fact_2_wf__hsubst,axiom,
    ! [Tr0: dtree,Tr: dtree] :
      ( ( gram_L864798063lle_wf @ Tr0 )
     => ( ( gram_L864798063lle_wf @ Tr )
       => ( gram_L864798063lle_wf @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) ) ) ) ).

% wf_hsubst
thf(fact_3_wf__rcut,axiom,
    ! [Tr0: dtree] :
      ( ( gram_L864798063lle_wf @ Tr0 )
     => ( gram_L864798063lle_wf @ ( gram_L1828378864e_rcut @ Tr0 ) ) ) ).

% wf_rcut
thf(fact_4_wf__deftr,axiom,
    ! [N: n] : ( gram_L864798063lle_wf @ ( gram_L1231612515_deftr @ N ) ) ).

% wf_deftr
thf(fact_5_rtr,axiom,
    ( ( root @ tr2 )
    = n2 ) ).

% rtr
thf(fact_6_n,axiom,
    member @ n @ n2 @ ns ).

% n
thf(fact_7_root__hsubst,axiom,
    ! [Tr0: dtree,Tr: dtree] :
      ( ( root @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) )
      = ( root @ Tr ) ) ).

% root_hsubst
thf(fact_8_wf__subtr,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr: dtree] :
      ( ( gram_L864798063lle_wf @ Tr1 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L864798063lle_wf @ Tr ) ) ) ).

% wf_subtr
thf(fact_9_hsubst__def,axiom,
    ( gram_L1004374585hsubst
    = ( ^ [Tr02: dtree] : ( unfold @ dtree @ gram_L1905609017ubst_r @ ( gram_L1905609002ubst_c @ Tr02 ) ) ) ) ).

% hsubst_def
thf(fact_10_hsubst__eq,axiom,
    ! [Tr: dtree,Tr0: dtree] :
      ( ( ( root @ Tr )
        = ( root @ Tr0 ) )
     => ( ( gram_L1004374585hsubst @ Tr0 @ Tr )
        = ( gram_L1004374585hsubst @ Tr0 @ Tr0 ) ) ) ).

% hsubst_eq
thf(fact_11_inFr__hsubst__notin,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Tr0: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( ~ ( member @ n @ ( root @ Tr0 ) @ Ns )
       => ( gram_L1333338417e_inFr @ Ns @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) @ T2 ) ) ) ).

% inFr_hsubst_notin
thf(fact_12_root__o__subst,axiom,
    ! [Tr0: dtree] :
      ( ( comp @ dtree @ n @ dtree @ root @ ( gram_L1004374585hsubst @ Tr0 ) )
      = root ) ).

% root_o_subst
thf(fact_13_wf__cont,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( gram_L864798063lle_wf @ Tr2 ) ) ) ).

% wf_cont
thf(fact_14_wf__pick,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( gram_L864798063lle_wf @ Tr0 )
     => ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
       => ( gram_L864798063lle_wf @ ( gram_L315592705e_pick @ Tr0 @ N ) ) ) ) ).

% wf_pick
thf(fact_15_root__deftr,axiom,
    ! [N: n] :
      ( ( root @ ( gram_L1231612515_deftr @ N ) )
      = N ) ).

% root_deftr
thf(fact_16_root__rcut,axiom,
    ! [Tr0: dtree] :
      ( ( root @ ( gram_L1828378864e_rcut @ Tr0 ) )
      = ( root @ Tr0 ) ) ).

% root_rcut
thf(fact_17_wf__inj,axiom,
    ! [Tr: dtree,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr ) )
         => ( ( ( root @ Tr1 )
              = ( root @ Tr22 ) )
            = ( Tr1 = Tr22 ) ) ) ) ) ).

% wf_inj
thf(fact_18_pick,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
     => ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ ( gram_L315592705e_pick @ Tr0 @ N ) @ Tr0 )
        & ( ( root @ ( gram_L315592705e_pick @ Tr0 @ N ) )
          = N ) ) ) ).

% pick
thf(fact_19_inFr_OInd,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr1: dtree,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( gram_L1333338417e_inFr @ Ns @ Tr1 @ T2 )
         => ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ) ) ).

% inFr.Ind
thf(fact_20_inItr_OInd,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr1: dtree,N: n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( gram_L830233218_inItr @ Ns @ Tr1 @ N )
         => ( gram_L830233218_inItr @ Ns @ Tr @ N ) ) ) ) ).

% inItr.Ind
thf(fact_21_root__pick,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
     => ( ( root @ ( gram_L315592705e_pick @ Tr0 @ N ) )
        = N ) ) ).

% root_pick
thf(fact_22_inItr_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L830233218_inItr @ Ns @ Tr @ ( root @ Tr ) ) ) ).

% inItr.Base
thf(fact_23_subtr_ORefl,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L716654942_subtr @ Ns @ Tr @ Tr ) ) ).

% subtr.Refl
thf(fact_24_subtr_OStep,axiom,
    ! [Tr3: dtree,Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( member @ n @ ( root @ Tr3 ) @ Ns )
     => ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr3 ) )
         => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr.Step
thf(fact_25_subtr__inFr,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Tr1: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L1333338417e_inFr @ Ns @ Tr1 @ T2 ) ) ) ).

% subtr_inFr
thf(fact_26_subtr__pick,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
     => ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ ( gram_L315592705e_pick @ Tr0 @ N ) @ Tr0 ) ) ).

% subtr_pick
thf(fact_27_inItr_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: n] :
      ( ( gram_L830233218_inItr @ A1 @ A2 @ A3 )
     => ( ( ( A3
            = ( root @ A2 ) )
         => ~ ( member @ n @ ( root @ A2 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A2 ) @ A1 )
           => ! [Tr12: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ A2 ) )
               => ~ ( gram_L830233218_inItr @ A1 @ Tr12 @ A3 ) ) ) ) ) ).

% inItr.cases
thf(fact_28_inItr_Osimps,axiom,
    ( gram_L830233218_inItr
    = ( ^ [A12: set @ n,A22: dtree,A32: n] :
          ( ? [Tr4: dtree,Ns2: set @ n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32
                = ( root @ Tr4 ) )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 ) )
          | ? [Tr4: dtree,Ns2: set @ n,Tr13: dtree,N2: n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32 = N2 )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr4 ) )
              & ( gram_L830233218_inItr @ Ns2 @ Tr13 @ N2 ) ) ) ) ) ).

% inItr.simps
thf(fact_29_inItr__subtr,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ? [Tr5: dtree] :
          ( ( gram_L716654942_subtr @ Ns @ Tr5 @ Tr )
          & ( ( root @ Tr5 )
            = N ) ) ) ).

% inItr_subtr
thf(fact_30_subtr_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: dtree] :
      ( ( gram_L716654942_subtr @ A1 @ A2 @ A3 )
     => ( ( ( A3 = A2 )
         => ~ ( member @ n @ ( root @ A2 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A3 ) @ A1 )
           => ! [Tr23: dtree] :
                ( ( gram_L716654942_subtr @ A1 @ A2 @ Tr23 )
               => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr23 ) @ ( cont @ A3 ) ) ) ) ) ) ).

% subtr.cases
thf(fact_31_subtr_Osimps,axiom,
    ( gram_L716654942_subtr
    = ( ^ [A12: set @ n,A22: dtree,A32: dtree] :
          ( ? [Tr4: dtree,Ns2: set @ n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32 = Tr4 )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 ) )
          | ? [Tr32: dtree,Ns2: set @ n,Tr13: dtree,Tr24: dtree] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr13 )
              & ( A32 = Tr32 )
              & ( member @ n @ ( root @ Tr32 ) @ Ns2 )
              & ( gram_L716654942_subtr @ Ns2 @ Tr13 @ Tr24 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr24 ) @ ( cont @ Tr32 ) ) ) ) ) ) ).

% subtr.simps
thf(fact_32_subtr__StepL,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr22: dtree,Tr3: dtree] :
      ( ( member @ n @ ( root @ Tr1 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr22 ) )
       => ( ( gram_L716654942_subtr @ Ns @ Tr22 @ Tr3 )
         => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr_StepL
thf(fact_33_subtr__deftr,axiom,
    ! [Ns: set @ n,Tr2: dtree,N: n] :
      ( ( gram_L716654942_subtr @ Ns @ Tr2 @ ( gram_L1231612515_deftr @ N ) )
     => ( Tr2
        = ( gram_L1231612515_deftr @ ( root @ Tr2 ) ) ) ) ).

% subtr_deftr
thf(fact_34_subtr__inItr,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n,Tr1: dtree] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L830233218_inItr @ Ns @ Tr1 @ N ) ) ) ).

% subtr_inItr
thf(fact_35_subtr__trans,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Tr3: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr22 @ Tr3 )
       => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr3 ) ) ) ).

% subtr_trans
thf(fact_36_hsubst__c__def,axiom,
    ( gram_L1905609002ubst_c
    = ( ^ [Tr02: dtree,Tr4: dtree] :
          ( if @ ( set @ ( sum_sum @ t @ dtree ) )
          @ ( ( root @ Tr4 )
            = ( root @ Tr02 ) )
          @ ( cont @ Tr02 )
          @ ( cont @ Tr4 ) ) ) ) ).

% hsubst_c_def
thf(fact_37_hsubst__r__def,axiom,
    gram_L1905609017ubst_r = root ).

% hsubst_r_def
thf(fact_38_inFr__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inFr_root_in
thf(fact_39_inItr_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: n,P: ( set @ n ) > dtree > n > $o] :
      ( ( gram_L830233218_inItr @ X1 @ X2 @ X3 )
     => ( ! [Tr6: dtree,Ns3: set @ n] :
            ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
           => ( P @ Ns3 @ Tr6 @ ( root @ Tr6 ) ) )
       => ( ! [Tr6: dtree,Ns3: set @ n,Tr12: dtree,N3: n] :
              ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr6 ) )
               => ( ( gram_L830233218_inItr @ Ns3 @ Tr12 @ N3 )
                 => ( ( P @ Ns3 @ Tr12 @ N3 )
                   => ( P @ Ns3 @ Tr6 @ N3 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% inItr.inducts
thf(fact_40_inItr__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inItr_root_in
thf(fact_41_not__root__inFr,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ~ ( member @ n @ ( root @ Tr ) @ Ns )
     => ~ ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ).

% not_root_inFr
thf(fact_42_subtr_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: dtree,P: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ X1 @ X2 @ X3 )
     => ( ! [Tr6: dtree,Ns3: set @ n] :
            ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
           => ( P @ Ns3 @ Tr6 @ Tr6 ) )
       => ( ! [Tr33: dtree,Ns3: set @ n,Tr12: dtree,Tr23: dtree] :
              ( ( member @ n @ ( root @ Tr33 ) @ Ns3 )
             => ( ( gram_L716654942_subtr @ Ns3 @ Tr12 @ Tr23 )
               => ( ( P @ Ns3 @ Tr12 @ Tr23 )
                 => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr23 ) @ ( cont @ Tr33 ) )
                   => ( P @ Ns3 @ Tr12 @ Tr33 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% subtr.inducts
thf(fact_43_subtr__inductL,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Phi: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ! [Ns3: set @ n,Tr6: dtree] : ( Phi @ Ns3 @ Tr6 @ Tr6 )
       => ( ! [Ns3: set @ n,Tr12: dtree,Tr23: dtree,Tr33: dtree] :
              ( ( member @ n @ ( root @ Tr12 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr23 ) )
               => ( ( gram_L716654942_subtr @ Ns3 @ Tr23 @ Tr33 )
                 => ( ( Phi @ Ns3 @ Tr23 @ Tr33 )
                   => ( Phi @ Ns3 @ Tr12 @ Tr33 ) ) ) ) )
         => ( Phi @ Ns @ Tr1 @ Tr22 ) ) ) ) ).

% subtr_inductL
thf(fact_44_subtr__rootL__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr1 ) @ Ns ) ) ).

% subtr_rootL_in
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A4: A,P: A > $o] :
      ( ( member @ A @ A4 @ ( collect @ A @ P ) )
      = ( P @ A4 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ X4 )
          = ( Q @ X4 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X4: A] :
          ( ( F @ X4 )
          = ( G @ X4 ) )
     => ( F = G ) ) ).

% ext
thf(fact_49_subtr__rootR__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr22 ) @ Ns ) ) ).

% subtr_rootR_in
thf(fact_50_subtr__UNIV__inductL,axiom,
    ! [Tr1: dtree,Tr22: dtree,Phi: dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ Tr1 @ Tr22 )
     => ( ! [Tr6: dtree] : ( Phi @ Tr6 @ Tr6 )
       => ( ! [Tr12: dtree,Tr23: dtree,Tr33: dtree] :
              ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr23 ) )
             => ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ Tr23 @ Tr33 )
               => ( ( Phi @ Tr23 @ Tr33 )
                 => ( Phi @ Tr12 @ Tr33 ) ) ) )
         => ( Phi @ Tr1 @ Tr22 ) ) ) ) ).

% subtr_UNIV_inductL
thf(fact_51_subtrOf__root,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( ( gram_L1614515765ubtrOf @ Tr @ ( root @ Tr2 ) )
          = Tr2 ) ) ) ).

% subtrOf_root
thf(fact_52_H__r__def,axiom,
    ( gram_L1221482026le_H_r
    = ( ^ [Tr02: dtree,N2: n] : ( root @ ( gram_L315592705e_pick @ Tr02 @ N2 ) ) ) ) ).

% H_r_def
thf(fact_53_inFrr__def,axiom,
    ( gram_L805317505_inFrr
    = ( ^ [Ns2: set @ n,Tr4: dtree,T3: t] :
        ? [Tr7: dtree] :
          ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr7 ) @ ( cont @ Tr4 ) )
          & ( gram_L1333338417e_inFr @ Ns2 @ Tr7 @ T3 ) ) ) ) ).

% inFrr_def
thf(fact_54_sum_Oinject_I2_J,axiom,
    ! [A: $tType,B: $tType,X2: B,Y2: B] :
      ( ( ( sum_Inr @ B @ A @ X2 )
        = ( sum_Inr @ B @ A @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% sum.inject(2)
thf(fact_55_old_Osum_Oinject_I2_J,axiom,
    ! [A: $tType,B: $tType,B2: B,B3: B] :
      ( ( ( sum_Inr @ B @ A @ B2 )
        = ( sum_Inr @ B @ A @ B3 ) )
      = ( B2 = B3 ) ) ).

% old.sum.inject(2)
thf(fact_56_unfold_I1_J,axiom,
    ! [A: $tType,Rt: A > n,Ct: A > ( set @ ( sum_sum @ t @ A ) ),B2: A] :
      ( ( root @ ( unfold @ A @ Rt @ Ct @ B2 ) )
      = ( Rt @ B2 ) ) ).

% unfold(1)
thf(fact_57_comp__apply,axiom,
    ! [C: $tType,A: $tType,B: $tType] :
      ( ( comp @ B @ A @ C )
      = ( ^ [F2: B > A,G2: C > B,X: C] : ( F2 @ ( G2 @ X ) ) ) ) ).

% comp_apply
thf(fact_58_UNIV__I,axiom,
    ! [A: $tType,X5: A] : ( member @ A @ X5 @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_I
thf(fact_59_iso__tuple__UNIV__I,axiom,
    ! [A: $tType,X5: A] : ( member @ A @ X5 @ ( top_top @ ( set @ A ) ) ) ).

% iso_tuple_UNIV_I
thf(fact_60_top__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( top @ C @ ( type2 @ C ) )
     => ( ( top_top @ ( D > C ) )
        = ( ^ [X: D] : ( top_top @ C ) ) ) ) ).

% top_apply
thf(fact_61_top__set__def,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( set @ A ) )
      = ( collect @ A @ ( top_top @ ( A > $o ) ) ) ) ).

% top_set_def
thf(fact_62_UNIV__witness,axiom,
    ! [A: $tType] :
    ? [X4: A] : ( member @ A @ X4 @ ( top_top @ ( set @ A ) ) ) ).

% UNIV_witness
thf(fact_63_UNIV__eq__I,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ! [X4: A] : ( member @ A @ X4 @ A5 )
     => ( ( top_top @ ( set @ A ) )
        = A5 ) ) ).

% UNIV_eq_I
thf(fact_64_comp__eq__dest__lhs,axiom,
    ! [C: $tType,B: $tType,A: $tType,A4: C > B,B2: A > C,C2: A > B,V: A] :
      ( ( ( comp @ C @ B @ A @ A4 @ B2 )
        = C2 )
     => ( ( A4 @ ( B2 @ V ) )
        = ( C2 @ V ) ) ) ).

% comp_eq_dest_lhs
thf(fact_65_comp__eq__elim,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,A4: C > B,B2: A > C,C2: D > B,D2: A > D] :
      ( ( ( comp @ C @ B @ A @ A4 @ B2 )
        = ( comp @ D @ B @ A @ C2 @ D2 ) )
     => ! [V2: A] :
          ( ( A4 @ ( B2 @ V2 ) )
          = ( C2 @ ( D2 @ V2 ) ) ) ) ).

% comp_eq_elim
thf(fact_66_comp__eq__dest,axiom,
    ! [C: $tType,B: $tType,D: $tType,A: $tType,A4: C > B,B2: A > C,C2: D > B,D2: A > D,V: A] :
      ( ( ( comp @ C @ B @ A @ A4 @ B2 )
        = ( comp @ D @ B @ A @ C2 @ D2 ) )
     => ( ( A4 @ ( B2 @ V ) )
        = ( C2 @ ( D2 @ V ) ) ) ) ).

% comp_eq_dest
thf(fact_67_comp__assoc,axiom,
    ! [B: $tType,D: $tType,C: $tType,A: $tType,F: D > B,G: C > D,H: A > C] :
      ( ( comp @ C @ B @ A @ ( comp @ D @ B @ C @ F @ G ) @ H )
      = ( comp @ D @ B @ A @ F @ ( comp @ C @ D @ A @ G @ H ) ) ) ).

% comp_assoc
thf(fact_68_comp__def,axiom,
    ! [A: $tType,C: $tType,B: $tType] :
      ( ( comp @ B @ C @ A )
      = ( ^ [F2: B > C,G2: A > B,X: A] : ( F2 @ ( G2 @ X ) ) ) ) ).

% comp_def
thf(fact_69_Inr__inject,axiom,
    ! [A: $tType,B: $tType,X5: B,Y: B] :
      ( ( ( sum_Inr @ B @ A @ X5 )
        = ( sum_Inr @ B @ A @ Y ) )
     => ( X5 = Y ) ) ).

% Inr_inject
thf(fact_70_dtree__cong,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( ( root @ Tr )
        = ( root @ Tr2 ) )
     => ( ( ( cont @ Tr )
          = ( cont @ Tr2 ) )
       => ( Tr = Tr2 ) ) ) ).

% dtree_cong
thf(fact_71_old_Osum_Osimps_I8_J,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > T,F22: B > T,B2: B] :
      ( ( sum_rec_sum @ A @ T @ B @ F1 @ F22 @ ( sum_Inr @ B @ A @ B2 ) )
      = ( F22 @ B2 ) ) ).

% old.sum.simps(8)
thf(fact_72_root__H,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
     => ( ( root @ ( gram_L1451583624elle_H @ Tr0 @ N ) )
        = N ) ) ).

% root_H
thf(fact_73_Node__root__cont,axiom,
    ! [Tr: dtree] :
      ( ( node @ ( root @ Tr ) @ ( cont @ Tr ) )
      = Tr ) ).

% Node_root_cont
thf(fact_74_wf__H,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( gram_L864798063lle_wf @ Tr0 )
     => ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
       => ( gram_L864798063lle_wf @ ( gram_L1451583624elle_H @ Tr0 @ N ) ) ) ) ).

% wf_H
thf(fact_75_subtr__H,axiom,
    ! [Tr0: dtree,N: n,Tr1: dtree] :
      ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N )
     => ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ Tr1 @ ( gram_L1451583624elle_H @ Tr0 @ N ) )
       => ? [N1: n] :
            ( ( gram_L830233218_inItr @ ( top_top @ ( set @ n ) ) @ Tr0 @ N1 )
            & ( Tr1
              = ( gram_L1451583624elle_H @ Tr0 @ N1 ) ) ) ) ) ).

% subtr_H
thf(fact_76_inFr2__Ind,axiom,
    ! [Ns: set @ n,Tr1: dtree,T2: t,Tr: dtree] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr1 @ T2 )
     => ( ( member @ n @ ( root @ Tr ) @ Ns )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
         => ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 ) ) ) ) ).

% inFr2_Ind
thf(fact_77_reg__def,axiom,
    ( gram_L1918716148le_reg
    = ( ^ [F2: n > dtree,Tr4: dtree] :
        ! [Tr7: dtree] :
          ( ( gram_L716654942_subtr @ ( top_top @ ( set @ n ) ) @ Tr7 @ Tr4 )
         => ( Tr7
            = ( F2 @ ( root @ Tr7 ) ) ) ) ) ) ).

% reg_def
thf(fact_78_top1I,axiom,
    ! [A: $tType,X5: A] : ( top_top @ ( A > $o ) @ X5 ) ).

% top1I
thf(fact_79_root__Node,axiom,
    ! [N: n,As: set @ ( sum_sum @ t @ dtree )] :
      ( ( root @ ( node @ N @ As ) )
      = N ) ).

% root_Node
thf(fact_80_rcut__eq,axiom,
    ! [Tr0: dtree] :
      ( ( ( gram_L1828378864e_rcut @ Tr0 )
        = Tr0 )
      = ( gram_L1918716148le_reg @ ( gram_L1451583624elle_H @ Tr0 ) @ Tr0 ) ) ).

% rcut_eq
thf(fact_81_rcut__reg,axiom,
    ! [Tr0: dtree] :
      ( ( gram_L1918716148le_reg @ ( gram_L1451583624elle_H @ Tr0 ) @ Tr0 )
     => ( ( gram_L1828378864e_rcut @ Tr0 )
        = Tr0 ) ) ).

% rcut_reg
thf(fact_82_reg__rcut,axiom,
    ! [Tr0: dtree] : ( gram_L1918716148le_reg @ ( gram_L1451583624elle_H @ Tr0 ) @ ( gram_L1828378864e_rcut @ Tr0 ) ) ).

% reg_rcut
thf(fact_83_reg__root,axiom,
    ! [F: n > dtree,Tr: dtree] :
      ( ( gram_L1918716148le_reg @ F @ Tr )
     => ( ( F @ ( root @ Tr ) )
        = Tr ) ) ).

% reg_root
thf(fact_84_reg__subtr,axiom,
    ! [F: n > dtree,Tr: dtree,Ns: set @ n,Tr2: dtree] :
      ( ( gram_L1918716148le_reg @ F @ Tr )
     => ( ( gram_L716654942_subtr @ Ns @ Tr2 @ Tr )
       => ( gram_L1918716148le_reg @ F @ Tr2 ) ) ) ).

% reg_subtr
thf(fact_85_inFr2__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inFr2_root_in
thf(fact_86_inFr__inFr2,axiom,
    gram_L1333338417e_inFr = gram_L805317441_inFr2 ).

% inFr_inFr2
thf(fact_87_reg__deftr,axiom,
    ! [N: n] : ( gram_L1918716148le_reg @ gram_L1231612515_deftr @ ( gram_L1231612515_deftr @ N ) ) ).

% reg_deftr
thf(fact_88_reg__Inr__cont,axiom,
    ! [F: n > dtree,Tr: dtree,Tr2: dtree] :
      ( ( gram_L1918716148le_reg @ F @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( gram_L1918716148le_reg @ F @ Tr2 ) ) ) ).

% reg_Inr_cont
thf(fact_89_reg__def2,axiom,
    ( gram_L1918716148le_reg
    = ( ^ [F2: n > dtree,Tr4: dtree] :
        ! [Ns2: set @ n,Tr7: dtree] :
          ( ( gram_L716654942_subtr @ Ns2 @ Tr7 @ Tr4 )
         => ( Tr7
            = ( F2 @ ( root @ Tr7 ) ) ) ) ) ) ).

% reg_def2
thf(fact_90_root__H__pick,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( root @ ( gram_L1451583624elle_H @ Tr0 @ N ) )
      = ( root @ ( gram_L315592705e_pick @ Tr0 @ N ) ) ) ).

% root_H_pick
thf(fact_91_rcut__def,axiom,
    ( gram_L1828378864e_rcut
    = ( ^ [Tr02: dtree] : ( gram_L1451583624elle_H @ Tr02 @ ( root @ Tr02 ) ) ) ) ).

% rcut_def
thf(fact_92_H__def,axiom,
    ( gram_L1451583624elle_H
    = ( ^ [Tr02: dtree] : ( unfold @ n @ ( gram_L1221482026le_H_r @ Tr02 ) @ ( gram_L1221482011le_H_c @ Tr02 ) ) ) ) ).

% H_def
thf(fact_93_top__empty__eq,axiom,
    ! [A: $tType] :
      ( ( top_top @ ( A > $o ) )
      = ( ^ [X: A] : ( member @ A @ X @ ( top_top @ ( set @ A ) ) ) ) ) ).

% top_empty_eq
thf(fact_94_regular__def2,axiom,
    ( gram_L646766332egular
    = ( ^ [Tr4: dtree] :
        ? [F2: n > dtree] :
          ( ( gram_L1918716148le_reg @ F2 @ Tr4 )
          & ! [N2: n] :
              ( ( root @ ( F2 @ N2 ) )
              = N2 ) ) ) ) ).

% regular_def2
thf(fact_95_top__conj_I2_J,axiom,
    ! [A: $tType,P: $o,X5: A] :
      ( ( P
        & ( top_top @ ( A > $o ) @ X5 ) )
      = P ) ).

% top_conj(2)
thf(fact_96_top__conj_I1_J,axiom,
    ! [A: $tType,X5: A,P: $o] :
      ( ( ( top_top @ ( A > $o ) @ X5 )
        & P )
      = P ) ).

% top_conj(1)
thf(fact_97_inFr2_OInd,axiom,
    ! [Tr1: dtree,Tr: dtree,Ns1: set @ n,T2: t] :
      ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
     => ( ( gram_L805317441_inFr2 @ Ns1 @ Tr1 @ T2 )
       => ( gram_L805317441_inFr2 @ ( insert @ n @ ( root @ Tr ) @ Ns1 ) @ Tr @ T2 ) ) ) ).

% inFr2.Ind
thf(fact_98_insertCI,axiom,
    ! [A: $tType,A4: A,B4: set @ A,B2: A] :
      ( ( ~ ( member @ A @ A4 @ B4 )
       => ( A4 = B2 ) )
     => ( member @ A @ A4 @ ( insert @ A @ B2 @ B4 ) ) ) ).

% insertCI
thf(fact_99_insert__iff,axiom,
    ! [A: $tType,A4: A,B2: A,A5: set @ A] :
      ( ( member @ A @ A4 @ ( insert @ A @ B2 @ A5 ) )
      = ( ( A4 = B2 )
        | ( member @ A @ A4 @ A5 ) ) ) ).

% insert_iff
thf(fact_100_insert__absorb2,axiom,
    ! [A: $tType,X5: A,A5: set @ A] :
      ( ( insert @ A @ X5 @ ( insert @ A @ X5 @ A5 ) )
      = ( insert @ A @ X5 @ A5 ) ) ).

% insert_absorb2
thf(fact_101_insertE,axiom,
    ! [A: $tType,A4: A,B2: A,A5: set @ A] :
      ( ( member @ A @ A4 @ ( insert @ A @ B2 @ A5 ) )
     => ( ( A4 != B2 )
       => ( member @ A @ A4 @ A5 ) ) ) ).

% insertE
thf(fact_102_insertI1,axiom,
    ! [A: $tType,A4: A,B4: set @ A] : ( member @ A @ A4 @ ( insert @ A @ A4 @ B4 ) ) ).

% insertI1
thf(fact_103_insertI2,axiom,
    ! [A: $tType,A4: A,B4: set @ A,B2: A] :
      ( ( member @ A @ A4 @ B4 )
     => ( member @ A @ A4 @ ( insert @ A @ B2 @ B4 ) ) ) ).

% insertI2
thf(fact_104_Set_Oset__insert,axiom,
    ! [A: $tType,X5: A,A5: set @ A] :
      ( ( member @ A @ X5 @ A5 )
     => ~ ! [B5: set @ A] :
            ( ( A5
              = ( insert @ A @ X5 @ B5 ) )
           => ( member @ A @ X5 @ B5 ) ) ) ).

% Set.set_insert
thf(fact_105_insert__ident,axiom,
    ! [A: $tType,X5: A,A5: set @ A,B4: set @ A] :
      ( ~ ( member @ A @ X5 @ A5 )
     => ( ~ ( member @ A @ X5 @ B4 )
       => ( ( ( insert @ A @ X5 @ A5 )
            = ( insert @ A @ X5 @ B4 ) )
          = ( A5 = B4 ) ) ) ) ).

% insert_ident
thf(fact_106_insert__absorb,axiom,
    ! [A: $tType,A4: A,A5: set @ A] :
      ( ( member @ A @ A4 @ A5 )
     => ( ( insert @ A @ A4 @ A5 )
        = A5 ) ) ).

% insert_absorb
thf(fact_107_insert__eq__iff,axiom,
    ! [A: $tType,A4: A,A5: set @ A,B2: A,B4: set @ A] :
      ( ~ ( member @ A @ A4 @ A5 )
     => ( ~ ( member @ A @ B2 @ B4 )
       => ( ( ( insert @ A @ A4 @ A5 )
            = ( insert @ A @ B2 @ B4 ) )
          = ( ( ( A4 = B2 )
             => ( A5 = B4 ) )
            & ( ( A4 != B2 )
             => ? [C3: set @ A] :
                  ( ( A5
                    = ( insert @ A @ B2 @ C3 ) )
                  & ~ ( member @ A @ B2 @ C3 )
                  & ( B4
                    = ( insert @ A @ A4 @ C3 ) )
                  & ~ ( member @ A @ A4 @ C3 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_108_insert__commute,axiom,
    ! [A: $tType,X5: A,Y: A,A5: set @ A] :
      ( ( insert @ A @ X5 @ ( insert @ A @ Y @ A5 ) )
      = ( insert @ A @ Y @ ( insert @ A @ X5 @ A5 ) ) ) ).

% insert_commute
thf(fact_109_mk__disjoint__insert,axiom,
    ! [A: $tType,A4: A,A5: set @ A] :
      ( ( member @ A @ A4 @ A5 )
     => ? [B5: set @ A] :
          ( ( A5
            = ( insert @ A @ A4 @ B5 ) )
          & ~ ( member @ A @ A4 @ B5 ) ) ) ).

% mk_disjoint_insert
thf(fact_110_insert__UNIV,axiom,
    ! [A: $tType,X5: A] :
      ( ( insert @ A @ X5 @ ( top_top @ ( set @ A ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% insert_UNIV
thf(fact_111_regular__subtr,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr2: dtree] :
      ( ( gram_L646766332egular @ Tr )
     => ( ( gram_L716654942_subtr @ Ns @ Tr2 @ Tr )
       => ( gram_L646766332egular @ Tr2 ) ) ) ).

% regular_subtr
thf(fact_112_regular__def,axiom,
    ( gram_L646766332egular
    = ( ^ [Tr4: dtree] :
        ? [F2: n > dtree] : ( gram_L1918716148le_reg @ F2 @ Tr4 ) ) ) ).

% regular_def
thf(fact_113_regular__rcut,axiom,
    ! [Tr0: dtree] : ( gram_L646766332egular @ ( gram_L1828378864e_rcut @ Tr0 ) ) ).

% regular_rcut
thf(fact_114_rewriteR__comp__comp2,axiom,
    ! [C: $tType,B: $tType,E: $tType,D: $tType,A: $tType,G: C > B,H: A > C,R1: D > B,R2: A > D,F: B > E,L: D > E] :
      ( ( ( comp @ C @ B @ A @ G @ H )
        = ( comp @ D @ B @ A @ R1 @ R2 ) )
     => ( ( ( comp @ B @ E @ D @ F @ R1 )
          = L )
       => ( ( comp @ C @ E @ A @ ( comp @ B @ E @ C @ F @ G ) @ H )
          = ( comp @ D @ E @ A @ L @ R2 ) ) ) ) ).

% rewriteR_comp_comp2
thf(fact_115_rewriteL__comp__comp2,axiom,
    ! [A: $tType,C: $tType,B: $tType,D: $tType,E: $tType,F: C > B,G: A > C,L1: D > B,L2: A > D,H: E > A,R: E > D] :
      ( ( ( comp @ C @ B @ A @ F @ G )
        = ( comp @ D @ B @ A @ L1 @ L2 ) )
     => ( ( ( comp @ A @ D @ E @ L2 @ H )
          = R )
       => ( ( comp @ C @ B @ E @ F @ ( comp @ A @ C @ E @ G @ H ) )
          = ( comp @ D @ B @ E @ L1 @ R ) ) ) ) ).

% rewriteL_comp_comp2
thf(fact_116_rewriteR__comp__comp,axiom,
    ! [C: $tType,D: $tType,B: $tType,A: $tType,G: C > B,H: A > C,R: A > B,F: B > D] :
      ( ( ( comp @ C @ B @ A @ G @ H )
        = R )
     => ( ( comp @ C @ D @ A @ ( comp @ B @ D @ C @ F @ G ) @ H )
        = ( comp @ B @ D @ A @ F @ R ) ) ) ).

% rewriteR_comp_comp
thf(fact_117_rewriteL__comp__comp,axiom,
    ! [C: $tType,B: $tType,A: $tType,D: $tType,F: C > B,G: A > C,L: A > B,H: D > A] :
      ( ( ( comp @ C @ B @ A @ F @ G )
        = L )
     => ( ( comp @ C @ B @ D @ F @ ( comp @ A @ C @ D @ G @ H ) )
        = ( comp @ A @ B @ D @ L @ H ) ) ) ).

% rewriteL_comp_comp
thf(fact_118_inFr__Ind__minus,axiom,
    ! [Ns1: set @ n,Tr1: dtree,T2: t,Tr: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns1 @ Tr1 @ T2 )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( gram_L1333338417e_inFr @ ( insert @ n @ ( root @ Tr ) @ Ns1 ) @ Tr @ T2 ) ) ) ).

% inFr_Ind_minus
thf(fact_119_inFr2_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: t,P: ( set @ n ) > dtree > t > $o] :
      ( ( gram_L805317441_inFr2 @ X1 @ X2 @ X3 )
     => ( ! [Tr6: dtree,Ns3: set @ n,T4: t] :
            ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
           => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T4 ) @ ( cont @ Tr6 ) )
             => ( P @ Ns3 @ Tr6 @ T4 ) ) )
       => ( ! [Tr12: dtree,Tr6: dtree,Ns12: set @ n,T4: t] :
              ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr6 ) )
             => ( ( gram_L805317441_inFr2 @ Ns12 @ Tr12 @ T4 )
               => ( ( P @ Ns12 @ Tr12 @ T4 )
                 => ( P @ ( insert @ n @ ( root @ Tr6 ) @ Ns12 ) @ Tr6 @ T4 ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% inFr2.inducts
thf(fact_120_inFr2_Osimps,axiom,
    ( gram_L805317441_inFr2
    = ( ^ [A12: set @ n,A22: dtree,A32: t] :
          ( ? [Tr4: dtree,Ns2: set @ n,T3: t] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32 = T3 )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T3 ) @ ( cont @ Tr4 ) ) )
          | ? [Tr13: dtree,Tr4: dtree,Ns13: set @ n,T3: t] :
              ( ( A12
                = ( insert @ n @ ( root @ Tr4 ) @ Ns13 ) )
              & ( A22 = Tr4 )
              & ( A32 = T3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr4 ) )
              & ( gram_L805317441_inFr2 @ Ns13 @ Tr13 @ T3 ) ) ) ) ) ).

% inFr2.simps
thf(fact_121_inFr2_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: t] :
      ( ( gram_L805317441_inFr2 @ A1 @ A2 @ A3 )
     => ( ( ( member @ n @ ( root @ A2 ) @ A1 )
         => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ A3 ) @ ( cont @ A2 ) ) )
       => ~ ! [Tr12: dtree,Tr6: dtree,Ns12: set @ n] :
              ( ( A1
                = ( insert @ n @ ( root @ Tr6 ) @ Ns12 ) )
             => ( ( A2 = Tr6 )
               => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr6 ) )
                 => ~ ( gram_L805317441_inFr2 @ Ns12 @ Tr12 @ A3 ) ) ) ) ) ) ).

% inFr2.cases
thf(fact_122_subtr2_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: dtree,P: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L1283001940subtr2 @ X1 @ X2 @ X3 )
     => ( ! [Tr6: dtree,Ns3: set @ n] :
            ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
           => ( P @ Ns3 @ Tr6 @ Tr6 ) )
       => ( ! [Tr12: dtree,Ns3: set @ n,Tr23: dtree,Tr33: dtree] :
              ( ( member @ n @ ( root @ Tr12 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr23 ) )
               => ( ( gram_L1283001940subtr2 @ Ns3 @ Tr23 @ Tr33 )
                 => ( ( P @ Ns3 @ Tr23 @ Tr33 )
                   => ( P @ Ns3 @ Tr12 @ Tr33 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% subtr2.inducts
thf(fact_123_subtr2__StepR,axiom,
    ! [Tr3: dtree,Ns: set @ n,Tr22: dtree,Tr1: dtree] :
      ( ( member @ n @ ( root @ Tr3 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr3 ) )
       => ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
         => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr2_StepR
thf(fact_124_old_Osum_Oinject_I1_J,axiom,
    ! [B: $tType,A: $tType,A4: A,A6: A] :
      ( ( ( sum_Inl @ A @ B @ A4 )
        = ( sum_Inl @ A @ B @ A6 ) )
      = ( A4 = A6 ) ) ).

% old.sum.inject(1)
thf(fact_125_sum_Oinject_I1_J,axiom,
    ! [B: $tType,A: $tType,X1: A,Y1: A] :
      ( ( ( sum_Inl @ A @ B @ X1 )
        = ( sum_Inl @ A @ B @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% sum.inject(1)
thf(fact_126_Inr__Inl__False,axiom,
    ! [B: $tType,A: $tType,X5: B,Y: A] :
      ( ( sum_Inr @ B @ A @ X5 )
     != ( sum_Inl @ A @ B @ Y ) ) ).

% Inr_Inl_False
thf(fact_127_Inl__Inr__False,axiom,
    ! [A: $tType,B: $tType,X5: A,Y: B] :
      ( ( sum_Inl @ A @ B @ X5 )
     != ( sum_Inr @ B @ A @ Y ) ) ).

% Inl_Inr_False
thf(fact_128_old_Osum_Osimps_I7_J,axiom,
    ! [B: $tType,T: $tType,A: $tType,F1: A > T,F22: B > T,A4: A] :
      ( ( sum_rec_sum @ A @ T @ B @ F1 @ F22 @ ( sum_Inl @ A @ B @ A4 ) )
      = ( F1 @ A4 ) ) ).

% old.sum.simps(7)
thf(fact_129_obj__sumE__f,axiom,
    ! [A: $tType,C: $tType,B: $tType,S: B,F: ( sum_sum @ A @ C ) > B,P: $o] :
      ( ! [X4: A] :
          ( ( S
            = ( F @ ( sum_Inl @ A @ C @ X4 ) ) )
         => P )
     => ( ! [X4: C] :
            ( ( S
              = ( F @ ( sum_Inr @ C @ A @ X4 ) ) )
           => P )
       => ! [X6: sum_sum @ A @ C] :
            ( ( S
              = ( F @ X6 ) )
           => P ) ) ) ).

% obj_sumE_f
thf(fact_130_old_Osum_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( sum_sum @ A @ B ) > $o,Sum: sum_sum @ A @ B] :
      ( ! [A7: A] : ( P @ ( sum_Inl @ A @ B @ A7 ) )
     => ( ! [B6: B] : ( P @ ( sum_Inr @ B @ A @ B6 ) )
       => ( P @ Sum ) ) ) ).

% old.sum.inducts
thf(fact_131_old_Osum_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: sum_sum @ A @ B] :
      ( ! [A7: A] :
          ( Y
         != ( sum_Inl @ A @ B @ A7 ) )
     => ~ ! [B6: B] :
            ( Y
           != ( sum_Inr @ B @ A @ B6 ) ) ) ).

% old.sum.exhaust
thf(fact_132_split__sum__all,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [P2: ( sum_sum @ A @ B ) > $o] :
          ! [X7: sum_sum @ A @ B] : ( P2 @ X7 ) )
      = ( ^ [P3: ( sum_sum @ A @ B ) > $o] :
            ( ! [X: A] : ( P3 @ ( sum_Inl @ A @ B @ X ) )
            & ! [X: B] : ( P3 @ ( sum_Inr @ B @ A @ X ) ) ) ) ) ).

% split_sum_all
thf(fact_133_split__sum__ex,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [P2: ( sum_sum @ A @ B ) > $o] :
          ? [X7: sum_sum @ A @ B] : ( P2 @ X7 ) )
      = ( ^ [P3: ( sum_sum @ A @ B ) > $o] :
            ( ? [X: A] : ( P3 @ ( sum_Inl @ A @ B @ X ) )
            | ? [X: B] : ( P3 @ ( sum_Inr @ B @ A @ X ) ) ) ) ) ).

% split_sum_ex
thf(fact_134_Inr__not__Inl,axiom,
    ! [B: $tType,A: $tType,B2: B,A4: A] :
      ( ( sum_Inr @ B @ A @ B2 )
     != ( sum_Inl @ A @ B @ A4 ) ) ).

% Inr_not_Inl
thf(fact_135_sumE,axiom,
    ! [A: $tType,B: $tType,S: sum_sum @ A @ B] :
      ( ! [X4: A] :
          ( S
         != ( sum_Inl @ A @ B @ X4 ) )
     => ~ ! [Y3: B] :
            ( S
           != ( sum_Inr @ B @ A @ Y3 ) ) ) ).

% sumE
thf(fact_136_old_Osum_Odistinct_I1_J,axiom,
    ! [A: $tType,B: $tType,A4: A,B3: B] :
      ( ( sum_Inl @ A @ B @ A4 )
     != ( sum_Inr @ B @ A @ B3 ) ) ).

% old.sum.distinct(1)
thf(fact_137_old_Osum_Odistinct_I2_J,axiom,
    ! [B7: $tType,A8: $tType,B8: B7,A9: A8] :
      ( ( sum_Inr @ B7 @ A8 @ B8 )
     != ( sum_Inl @ A8 @ B7 @ A9 ) ) ).

% old.sum.distinct(2)
thf(fact_138_sum_Odistinct_I1_J,axiom,
    ! [A: $tType,B: $tType,X1: A,X2: B] :
      ( ( sum_Inl @ A @ B @ X1 )
     != ( sum_Inr @ B @ A @ X2 ) ) ).

% sum.distinct(1)
thf(fact_139_Inl__inject,axiom,
    ! [B: $tType,A: $tType,X5: A,Y: A] :
      ( ( ( sum_Inl @ A @ B @ X5 )
        = ( sum_Inl @ A @ B @ Y ) )
     => ( X5 = Y ) ) ).

% Inl_inject
thf(fact_140_subtr2__trans,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Tr3: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( ( gram_L1283001940subtr2 @ Ns @ Tr22 @ Tr3 )
       => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr3 ) ) ) ).

% subtr2_trans
thf(fact_141_subtr2_ORefl,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L1283001940subtr2 @ Ns @ Tr @ Tr ) ) ).

% subtr2.Refl
thf(fact_142_subtr2__rootL__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr1 ) @ Ns ) ) ).

% subtr2_rootL_in
thf(fact_143_subtr2__rootR__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr22 ) @ Ns ) ) ).

% subtr2_rootR_in
thf(fact_144_subtr__subtr2,axiom,
    gram_L716654942_subtr = gram_L1283001940subtr2 ).

% subtr_subtr2
thf(fact_145_inFr_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr ) )
       => ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ) ).

% inFr.Base
thf(fact_146_inFr__subtr,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ? [Tr5: dtree] :
          ( ( gram_L716654942_subtr @ Ns @ Tr5 @ Tr )
          & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr5 ) ) ) ) ).

% inFr_subtr
thf(fact_147_inFr2_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr ) )
       => ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 ) ) ) ).

% inFr2.Base
thf(fact_148_inFr_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: t] :
      ( ( gram_L1333338417e_inFr @ A1 @ A2 @ A3 )
     => ( ( ( member @ n @ ( root @ A2 ) @ A1 )
         => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ A3 ) @ ( cont @ A2 ) ) )
       => ~ ( ( member @ n @ ( root @ A2 ) @ A1 )
           => ! [Tr12: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ A2 ) )
               => ~ ( gram_L1333338417e_inFr @ A1 @ Tr12 @ A3 ) ) ) ) ) ).

% inFr.cases
thf(fact_149_inFr_Osimps,axiom,
    ( gram_L1333338417e_inFr
    = ( ^ [A12: set @ n,A22: dtree,A32: t] :
          ( ? [Tr4: dtree,Ns2: set @ n,T3: t] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32 = T3 )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T3 ) @ ( cont @ Tr4 ) ) )
          | ? [Tr4: dtree,Ns2: set @ n,Tr13: dtree,T3: t] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32 = T3 )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr4 ) )
              & ( gram_L1333338417e_inFr @ Ns2 @ Tr13 @ T3 ) ) ) ) ) ).

% inFr.simps
thf(fact_150_inFr_Oinducts,axiom,
    ! [X1: set @ n,X2: dtree,X3: t,P: ( set @ n ) > dtree > t > $o] :
      ( ( gram_L1333338417e_inFr @ X1 @ X2 @ X3 )
     => ( ! [Tr6: dtree,Ns3: set @ n,T4: t] :
            ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
           => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T4 ) @ ( cont @ Tr6 ) )
             => ( P @ Ns3 @ Tr6 @ T4 ) ) )
       => ( ! [Tr6: dtree,Ns3: set @ n,Tr12: dtree,T4: t] :
              ( ( member @ n @ ( root @ Tr6 ) @ Ns3 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr6 ) )
               => ( ( gram_L1333338417e_inFr @ Ns3 @ Tr12 @ T4 )
                 => ( ( P @ Ns3 @ Tr12 @ T4 )
                   => ( P @ Ns3 @ Tr6 @ T4 ) ) ) ) )
         => ( P @ X1 @ X2 @ X3 ) ) ) ) ).

% inFr.inducts
thf(fact_151_subtr2_OStep,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr22: dtree,Tr3: dtree] :
      ( ( member @ n @ ( root @ Tr1 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr22 ) )
       => ( ( gram_L1283001940subtr2 @ Ns @ Tr22 @ Tr3 )
         => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr3 ) ) ) ) ).

% subtr2.Step
thf(fact_152_subtr2_Ocases,axiom,
    ! [A1: set @ n,A2: dtree,A3: dtree] :
      ( ( gram_L1283001940subtr2 @ A1 @ A2 @ A3 )
     => ( ( ( A3 = A2 )
         => ~ ( member @ n @ ( root @ A2 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A2 ) @ A1 )
           => ! [Tr23: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ A2 ) @ ( cont @ Tr23 ) )
               => ~ ( gram_L1283001940subtr2 @ A1 @ Tr23 @ A3 ) ) ) ) ) ).

% subtr2.cases
thf(fact_153_subtr2_Osimps,axiom,
    ( gram_L1283001940subtr2
    = ( ^ [A12: set @ n,A22: dtree,A32: dtree] :
          ( ? [Tr4: dtree,Ns2: set @ n] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr4 )
              & ( A32 = Tr4 )
              & ( member @ n @ ( root @ Tr4 ) @ Ns2 ) )
          | ? [Tr13: dtree,Ns2: set @ n,Tr24: dtree,Tr32: dtree] :
              ( ( A12 = Ns2 )
              & ( A22 = Tr13 )
              & ( A32 = Tr32 )
              & ( member @ n @ ( root @ Tr13 ) @ Ns2 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr24 ) )
              & ( gram_L1283001940subtr2 @ Ns2 @ Tr24 @ Tr32 ) ) ) ) ) ).

% subtr2.simps
thf(fact_154_obj__sumE,axiom,
    ! [A: $tType,B: $tType,S: sum_sum @ A @ B] :
      ( ! [X4: A] :
          ( S
         != ( sum_Inl @ A @ B @ X4 ) )
     => ~ ! [X4: B] :
            ( S
           != ( sum_Inr @ B @ A @ X4 ) ) ) ).

% obj_sumE
thf(fact_155_Inl__cont__H,axiom,
    ! [Tr0: dtree,N: n] :
      ( ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ ( gram_L1451583624elle_H @ Tr0 @ N ) ) )
      = ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ ( gram_L315592705e_pick @ Tr0 @ N ) ) ) ) ).

% Inl_cont_H
thf(fact_156_Inl__cont__hsubst__eq,axiom,
    ! [Tr: dtree,Tr0: dtree] :
      ( ( ( root @ Tr )
        = ( root @ Tr0 ) )
     => ( ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) ) )
        = ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ Tr0 ) ) ) ) ).

% Inl_cont_hsubst_eq
thf(fact_157_Inl__cont__hsubst__neq,axiom,
    ! [Tr: dtree,Tr0: dtree] :
      ( ( ( root @ Tr )
       != ( root @ Tr0 ) )
     => ( ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) ) )
        = ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ Tr ) ) ) ) ).

% Inl_cont_hsubst_neq
thf(fact_158_vimageI,axiom,
    ! [B: $tType,A: $tType,F: B > A,A4: B,B2: A,B4: set @ A] :
      ( ( ( F @ A4 )
        = B2 )
     => ( ( member @ A @ B2 @ B4 )
       => ( member @ B @ A4 @ ( vimage @ B @ A @ F @ B4 ) ) ) ) ).

% vimageI
thf(fact_159_vimage__eq,axiom,
    ! [A: $tType,B: $tType,A4: A,F: A > B,B4: set @ B] :
      ( ( member @ A @ A4 @ ( vimage @ A @ B @ F @ B4 ) )
      = ( member @ B @ ( F @ A4 ) @ B4 ) ) ).

% vimage_eq
thf(fact_160_vimage__UNIV,axiom,
    ! [B: $tType,A: $tType,F: A > B] :
      ( ( vimage @ A @ B @ F @ ( top_top @ ( set @ B ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% vimage_UNIV
thf(fact_161_vimageD,axiom,
    ! [A: $tType,B: $tType,A4: A,F: A > B,A5: set @ B] :
      ( ( member @ A @ A4 @ ( vimage @ A @ B @ F @ A5 ) )
     => ( member @ B @ ( F @ A4 ) @ A5 ) ) ).

% vimageD
thf(fact_162_vimageE,axiom,
    ! [A: $tType,B: $tType,A4: A,F: A > B,B4: set @ B] :
      ( ( member @ A @ A4 @ ( vimage @ A @ B @ F @ B4 ) )
     => ( member @ B @ ( F @ A4 ) @ B4 ) ) ).

% vimageE
thf(fact_163_vimageI2,axiom,
    ! [B: $tType,A: $tType,F: B > A,A4: B,A5: set @ A] :
      ( ( member @ A @ ( F @ A4 ) @ A5 )
     => ( member @ B @ A4 @ ( vimage @ B @ A @ F @ A5 ) ) ) ).

% vimageI2
thf(fact_164_vimage__Collect,axiom,
    ! [B: $tType,A: $tType,P: B > $o,F: A > B,Q: A > $o] :
      ( ! [X4: A] :
          ( ( P @ ( F @ X4 ) )
          = ( Q @ X4 ) )
     => ( ( vimage @ A @ B @ F @ ( collect @ B @ P ) )
        = ( collect @ A @ Q ) ) ) ).

% vimage_Collect
thf(fact_165_set_Ocomp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: C > B,G: B > A] :
      ( ( comp @ ( set @ B ) @ ( set @ C ) @ ( set @ A ) @ ( vimage @ C @ B @ F ) @ ( vimage @ B @ A @ G ) )
      = ( vimage @ C @ A @ ( comp @ B @ A @ C @ G @ F ) ) ) ).

% set.comp
thf(fact_166_vimage__comp,axiom,
    ! [A: $tType,B: $tType,C: $tType,F: A > B,G: B > C,X5: set @ C] :
      ( ( vimage @ A @ B @ F @ ( vimage @ B @ C @ G @ X5 ) )
      = ( vimage @ A @ C @ ( comp @ B @ C @ A @ G @ F ) @ X5 ) ) ).

% vimage_comp
thf(fact_167_set_Ocompositionality,axiom,
    ! [C: $tType,B: $tType,A: $tType,F: C > B,G: B > A,Set: set @ A] :
      ( ( vimage @ C @ B @ F @ ( vimage @ B @ A @ G @ Set ) )
      = ( vimage @ C @ A @ ( comp @ B @ A @ C @ G @ F ) @ Set ) ) ).

% set.compositionality
thf(fact_168_not__arg__cong__Inr,axiom,
    ! [B: $tType,A: $tType,X5: A,Y: A] :
      ( ( X5 != Y )
     => ( ( sum_Inr @ A @ B @ X5 )
       != ( sum_Inr @ A @ B @ Y ) ) ) ).

% not_arg_cong_Inr
thf(fact_169_Inl__Inr__image__cong,axiom,
    ! [B: $tType,A: $tType,A5: set @ ( sum_sum @ A @ B ),B4: set @ ( sum_sum @ A @ B )] :
      ( ( ( vimage @ A @ ( sum_sum @ A @ B ) @ ( sum_Inl @ A @ B ) @ A5 )
        = ( vimage @ A @ ( sum_sum @ A @ B ) @ ( sum_Inl @ A @ B ) @ B4 ) )
     => ( ( ( vimage @ B @ ( sum_sum @ A @ B ) @ ( sum_Inr @ B @ A ) @ A5 )
          = ( vimage @ B @ ( sum_sum @ A @ B ) @ ( sum_Inr @ B @ A ) @ B4 ) )
       => ( A5 = B4 ) ) ) ).

% Inl_Inr_image_cong
thf(fact_170_inFr__self__hsubst,axiom,
    ! [Tr0: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr0 ) @ Ns )
     => ( ( gram_L1333338417e_inFr @ Ns @ ( gram_L1004374585hsubst @ Tr0 @ Tr0 ) @ T2 )
        = ( ( member @ t @ T2 @ ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ Tr0 ) ) )
          | ( gram_L805317505_inFrr @ ( minus_minus @ ( set @ n ) @ Ns @ ( insert @ n @ ( root @ Tr0 ) @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr0 @ T2 ) ) ) ) ).

% inFr_self_hsubst
thf(fact_171_inFr__hsubst__imp,axiom,
    ! [Ns: set @ n,Tr0: dtree,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) @ T2 )
     => ( ( member @ t @ T2 @ ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ Tr0 ) ) )
        | ( gram_L805317505_inFrr @ ( minus_minus @ ( set @ n ) @ Ns @ ( insert @ n @ ( root @ Tr0 ) @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr0 @ T2 )
        | ( gram_L1333338417e_inFr @ ( minus_minus @ ( set @ n ) @ Ns @ ( insert @ n @ ( root @ Tr0 ) @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr @ T2 ) ) ) ).

% inFr_hsubst_imp
thf(fact_172_bot__apply,axiom,
    ! [C: $tType,D: $tType] :
      ( ( bot @ C @ ( type2 @ C ) )
     => ( ( bot_bot @ ( D > C ) )
        = ( ^ [X: D] : ( bot_bot @ C ) ) ) ) ).

% bot_apply
thf(fact_173_empty__Collect__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( bot_bot @ ( set @ A ) )
        = ( collect @ A @ P ) )
      = ( ! [X: A] :
            ~ ( P @ X ) ) ) ).

% empty_Collect_eq
thf(fact_174_Collect__empty__eq,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( ( collect @ A @ P )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ! [X: A] :
            ~ ( P @ X ) ) ) ).

% Collect_empty_eq
thf(fact_175_all__not__in__conv,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( ! [X: A] :
            ~ ( member @ A @ X @ A5 ) )
      = ( A5
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% all_not_in_conv
thf(fact_176_empty__iff,axiom,
    ! [A: $tType,C2: A] :
      ~ ( member @ A @ C2 @ ( bot_bot @ ( set @ A ) ) ) ).

% empty_iff
thf(fact_177_Diff__idemp,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) @ B4 )
      = ( minus_minus @ ( set @ A ) @ A5 @ B4 ) ) ).

% Diff_idemp
thf(fact_178_Diff__iff,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) )
      = ( ( member @ A @ C2 @ A5 )
        & ~ ( member @ A @ C2 @ B4 ) ) ) ).

% Diff_iff
thf(fact_179_DiffI,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ A5 )
     => ( ~ ( member @ A @ C2 @ B4 )
       => ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) ) ) ) ).

% DiffI
thf(fact_180_singletonI,axiom,
    ! [A: $tType,A4: A] : ( member @ A @ A4 @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% singletonI
thf(fact_181_Diff__cancel,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A5 @ A5 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_cancel
thf(fact_182_empty__Diff,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ A5 )
      = ( bot_bot @ ( set @ A ) ) ) ).

% empty_Diff
thf(fact_183_Diff__empty,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A5 @ ( bot_bot @ ( set @ A ) ) )
      = A5 ) ).

% Diff_empty
thf(fact_184_Diff__insert0,axiom,
    ! [A: $tType,X5: A,A5: set @ A,B4: set @ A] :
      ( ~ ( member @ A @ X5 @ A5 )
     => ( ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ X5 @ B4 ) )
        = ( minus_minus @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% Diff_insert0
thf(fact_185_insert__Diff1,axiom,
    ! [A: $tType,X5: A,B4: set @ A,A5: set @ A] :
      ( ( member @ A @ X5 @ B4 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X5 @ A5 ) @ B4 )
        = ( minus_minus @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% insert_Diff1
thf(fact_186_vimage__empty,axiom,
    ! [B: $tType,A: $tType,F: A > B] :
      ( ( vimage @ A @ B @ F @ ( bot_bot @ ( set @ B ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% vimage_empty
thf(fact_187_insert__Diff__single,axiom,
    ! [A: $tType,A4: A,A5: set @ A] :
      ( ( insert @ A @ A4 @ ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( insert @ A @ A4 @ A5 ) ) ).

% insert_Diff_single
thf(fact_188_Diff__UNIV,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A5 @ ( top_top @ ( set @ A ) ) )
      = ( bot_bot @ ( set @ A ) ) ) ).

% Diff_UNIV
thf(fact_189_vimage__Diff,axiom,
    ! [A: $tType,B: $tType,F: A > B,A5: set @ B,B4: set @ B] :
      ( ( vimage @ A @ B @ F @ ( minus_minus @ ( set @ B ) @ A5 @ B4 ) )
      = ( minus_minus @ ( set @ A ) @ ( vimage @ A @ B @ F @ A5 ) @ ( vimage @ A @ B @ F @ B4 ) ) ) ).

% vimage_Diff
thf(fact_190_bot__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bot @ B @ ( type2 @ B ) )
     => ( ( bot_bot @ ( A > B ) )
        = ( ^ [X: A] : ( bot_bot @ B ) ) ) ) ).

% bot_fun_def
thf(fact_191_ex__in__conv,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( ? [X: A] : ( member @ A @ X @ A5 ) )
      = ( A5
       != ( bot_bot @ ( set @ A ) ) ) ) ).

% ex_in_conv
thf(fact_192_equals0I,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ! [Y3: A] :
          ~ ( member @ A @ Y3 @ A5 )
     => ( A5
        = ( bot_bot @ ( set @ A ) ) ) ) ).

% equals0I
thf(fact_193_equals0D,axiom,
    ! [A: $tType,A5: set @ A,A4: A] :
      ( ( A5
        = ( bot_bot @ ( set @ A ) ) )
     => ~ ( member @ A @ A4 @ A5 ) ) ).

% equals0D
thf(fact_194_emptyE,axiom,
    ! [A: $tType,A4: A] :
      ~ ( member @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ).

% emptyE
thf(fact_195_DiffD2,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) )
     => ~ ( member @ A @ C2 @ B4 ) ) ).

% DiffD2
thf(fact_196_DiffD1,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) )
     => ( member @ A @ C2 @ A5 ) ) ).

% DiffD1
thf(fact_197_DiffE,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) )
     => ~ ( ( member @ A @ C2 @ A5 )
         => ( member @ A @ C2 @ B4 ) ) ) ).

% DiffE
thf(fact_198_empty__not__UNIV,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
     != ( top_top @ ( set @ A ) ) ) ).

% empty_not_UNIV
thf(fact_199_singletonD,axiom,
    ! [A: $tType,B2: A,A4: A] :
      ( ( member @ A @ B2 @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( B2 = A4 ) ) ).

% singletonD
thf(fact_200_singleton__iff,axiom,
    ! [A: $tType,B2: A,A4: A] :
      ( ( member @ A @ B2 @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( B2 = A4 ) ) ).

% singleton_iff
thf(fact_201_doubleton__eq__iff,axiom,
    ! [A: $tType,A4: A,B2: A,C2: A,D2: A] :
      ( ( ( insert @ A @ A4 @ ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
        = ( insert @ A @ C2 @ ( insert @ A @ D2 @ ( bot_bot @ ( set @ A ) ) ) ) )
      = ( ( ( A4 = C2 )
          & ( B2 = D2 ) )
        | ( ( A4 = D2 )
          & ( B2 = C2 ) ) ) ) ).

% doubleton_eq_iff
thf(fact_202_insert__not__empty,axiom,
    ! [A: $tType,A4: A,A5: set @ A] :
      ( ( insert @ A @ A4 @ A5 )
     != ( bot_bot @ ( set @ A ) ) ) ).

% insert_not_empty
thf(fact_203_singleton__inject,axiom,
    ! [A: $tType,A4: A,B2: A] :
      ( ( ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) )
        = ( insert @ A @ B2 @ ( bot_bot @ ( set @ A ) ) ) )
     => ( A4 = B2 ) ) ).

% singleton_inject
thf(fact_204_insert__Diff__if,axiom,
    ! [A: $tType,X5: A,B4: set @ A,A5: set @ A] :
      ( ( ( member @ A @ X5 @ B4 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X5 @ A5 ) @ B4 )
          = ( minus_minus @ ( set @ A ) @ A5 @ B4 ) ) )
      & ( ~ ( member @ A @ X5 @ B4 )
       => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X5 @ A5 ) @ B4 )
          = ( insert @ A @ X5 @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) ) ) ) ) ).

% insert_Diff_if
thf(fact_205_Diff__insert__absorb,axiom,
    ! [A: $tType,X5: A,A5: set @ A] :
      ( ~ ( member @ A @ X5 @ A5 )
     => ( ( minus_minus @ ( set @ A ) @ ( insert @ A @ X5 @ A5 ) @ ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
        = A5 ) ) ).

% Diff_insert_absorb
thf(fact_206_Diff__insert2,axiom,
    ! [A: $tType,A5: set @ A,A4: A,B4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ A4 @ B4 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) @ B4 ) ) ).

% Diff_insert2
thf(fact_207_insert__Diff,axiom,
    ! [A: $tType,A4: A,A5: set @ A] :
      ( ( member @ A @ A4 @ A5 )
     => ( ( insert @ A @ A4 @ ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) )
        = A5 ) ) ).

% insert_Diff
thf(fact_208_Diff__insert,axiom,
    ! [A: $tType,A5: set @ A,A4: A,B4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ A5 @ ( insert @ A @ A4 @ B4 ) )
      = ( minus_minus @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A5 @ B4 ) @ ( insert @ A @ A4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Diff_insert
thf(fact_209_vimage__singleton__eq,axiom,
    ! [A: $tType,B: $tType,A4: A,F: A > B,B2: B] :
      ( ( member @ A @ A4 @ ( vimage @ A @ B @ F @ ( insert @ B @ B2 @ ( bot_bot @ ( set @ B ) ) ) ) )
      = ( ( F @ A4 )
        = B2 ) ) ).

% vimage_singleton_eq
thf(fact_210_inFr__hsubst__minus,axiom,
    ! [Ns: set @ n,Tr0: dtree,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ ( minus_minus @ ( set @ n ) @ Ns @ ( insert @ n @ ( root @ Tr0 ) @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr @ T2 )
     => ( gram_L1333338417e_inFr @ Ns @ ( gram_L1004374585hsubst @ Tr0 @ Tr ) @ T2 ) ) ).

% inFr_hsubst_minus
thf(fact_211_regular__inFr,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( gram_L646766332egular @ Tr )
     => ( ( member @ n @ ( root @ Tr ) @ Ns )
       => ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
         => ( ( member @ t @ T2 @ ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ Tr ) ) )
            | ? [Tr5: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr5 ) @ ( cont @ Tr ) )
                & ( gram_L1333338417e_inFr @ ( minus_minus @ ( set @ n ) @ Ns @ ( insert @ n @ ( root @ Tr ) @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr5 @ T2 ) ) ) ) ) ) ).

% regular_inFr
thf(fact_212_is__singletonI,axiom,
    ! [A: $tType,X5: A] : ( is_singleton @ A @ ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) ).

% is_singletonI
thf(fact_213__092_060open_062_092_060And_062n_H_O_AInr_An_H_A_092_060in_062_Atns_A_092_060Longrightarrow_062_A_092_060exists_062tr_H_O_AK_An_H_A_061_AFr_A_Ins_A_N_A_123n_125_J_Atr_H_A_092_060and_062_Awf_Atr_H_A_092_060and_062_Aroot_Atr_H_A_061_An_H_092_060close_062,axiom,
    ! [N4: n] :
      ( ( member @ ( sum_sum @ t @ n ) @ ( sum_Inr @ n @ t @ N4 ) @ tns )
     => ? [Tr5: dtree] :
          ( ( ( k @ N4 )
            = ( gram_L861583724lle_Fr @ ( minus_minus @ ( set @ n ) @ ns @ ( insert @ n @ n2 @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr5 ) )
          & ( gram_L864798063lle_wf @ Tr5 )
          & ( ( root @ Tr5 )
            = N4 ) ) ) ).

% \<open>\<And>n'. Inr n' \<in> tns \<Longrightarrow> \<exists>tr'. K n' = Fr (ns - {n}) tr' \<and> wf tr' \<and> root tr' = n'\<close>
thf(fact_214__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062ftr_O_A_I_092_060And_062n_H_O_AInr_An_H_A_092_060in_062_Atns_A_092_060Longrightarrow_062_AK_An_H_A_061_AFr_A_Ins_A_N_A_123n_125_J_A_Iftr_An_H_J_A_092_060and_062_Awf_A_Iftr_An_H_J_A_092_060and_062_Aroot_A_Iftr_An_H_J_A_061_An_H_J_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [Ftr: n > dtree] :
        ~ ! [N5: n] :
            ( ( member @ ( sum_sum @ t @ n ) @ ( sum_Inr @ n @ t @ N5 ) @ tns )
           => ( ( ( k @ N5 )
                = ( gram_L861583724lle_Fr @ ( minus_minus @ ( set @ n ) @ ns @ ( insert @ n @ n2 @ ( bot_bot @ ( set @ n ) ) ) ) @ ( Ftr @ N5 ) ) )
              & ( gram_L864798063lle_wf @ ( Ftr @ N5 ) )
              & ( ( root @ ( Ftr @ N5 ) )
                = N5 ) ) ) ).

% \<open>\<And>thesis. (\<And>ftr. (\<And>n'. Inr n' \<in> tns \<Longrightarrow> K n' = Fr (ns - {n}) (ftr n') \<and> wf (ftr n') \<and> root (ftr n') = n') \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_215_bot__empty__eq,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( A > $o ) )
      = ( ^ [X: A] : ( member @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% bot_empty_eq
thf(fact_216_bot__set__def,axiom,
    ! [A: $tType] :
      ( ( bot_bot @ ( set @ A ) )
      = ( collect @ A @ ( bot_bot @ ( A > $o ) ) ) ) ).

% bot_set_def
thf(fact_217_not__root__Fr,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ~ ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( gram_L861583724lle_Fr @ Ns @ Tr )
        = ( bot_bot @ ( set @ t ) ) ) ) ).

% not_root_Fr
thf(fact_218_is__singletonI_H,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( A5
       != ( bot_bot @ ( set @ A ) ) )
     => ( ! [X4: A,Y3: A] :
            ( ( member @ A @ X4 @ A5 )
           => ( ( member @ A @ Y3 @ A5 )
             => ( X4 = Y3 ) ) )
       => ( is_singleton @ A @ A5 ) ) ) ).

% is_singletonI'
thf(fact_219_is__singletonE,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( is_singleton @ A @ A5 )
     => ~ ! [X4: A] :
            ( A5
           != ( insert @ A @ X4 @ ( bot_bot @ ( set @ A ) ) ) ) ) ).

% is_singletonE
thf(fact_220_is__singleton__def,axiom,
    ! [A: $tType] :
      ( ( is_singleton @ A )
      = ( ^ [A10: set @ A] :
          ? [X: A] :
            ( A10
            = ( insert @ A @ X @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% is_singleton_def
thf(fact_221__C0_C,axiom,
    ! [N6: n] :
      ( ( member @ ( sum_sum @ t @ n ) @ ( sum_Inr @ n @ t @ N6 ) @ tns )
     => ( ( ( k @ N6 )
          = ( gram_L861583724lle_Fr @ ( minus_minus @ ( set @ n ) @ ns @ ( insert @ n @ n2 @ ( bot_bot @ ( set @ n ) ) ) ) @ ( ftr @ N6 ) ) )
        & ( gram_L864798063lle_wf @ ( ftr @ N6 ) )
        & ( ( root @ ( ftr @ N6 ) )
          = N6 ) ) ) ).

% "0"
thf(fact_222_P,axiom,
    member @ ( product_prod @ n @ ( set @ ( sum_sum @ t @ n ) ) ) @ ( product_Pair @ n @ ( set @ ( sum_sum @ t @ n ) ) @ n2 @ tns ) @ gram_L1451583632elle_P ).

% P
thf(fact_223_used,axiom,
    ! [N: n] :
    ? [Tns: set @ ( sum_sum @ t @ n )] : ( member @ ( product_prod @ n @ ( set @ ( sum_sum @ t @ n ) ) ) @ ( product_Pair @ n @ ( set @ ( sum_sum @ t @ n ) ) @ N @ Tns ) @ gram_L1451583632elle_P ) ).

% used
thf(fact_224_Fr__self__hsubst,axiom,
    ! [Tr0: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr0 ) @ Ns )
     => ( ( gram_L861583724lle_Fr @ Ns @ ( gram_L1004374585hsubst @ Tr0 @ Tr0 ) )
        = ( sup_sup @ ( set @ t ) @ ( vimage @ t @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree ) @ ( cont @ Tr0 ) ) @ ( gram_L1556062726le_Frr @ ( minus_minus @ ( set @ n ) @ Ns @ ( insert @ n @ ( root @ Tr0 ) @ ( bot_bot @ ( set @ n ) ) ) ) @ Tr0 ) ) ) ) ).

% Fr_self_hsubst
thf(fact_225_L__rec__notin,axiom,
    ! [N: n,Ns: set @ n] :
      ( ~ ( member @ n @ N @ Ns )
     => ( ( gram_L1451583628elle_L @ Ns @ N )
        = ( insert @ ( set @ t ) @ ( bot_bot @ ( set @ t ) ) @ ( bot_bot @ ( set @ ( set @ t ) ) ) ) ) ) ).

% L_rec_notin
thf(fact_226_UnCI,axiom,
    ! [A: $tType,C2: A,B4: set @ A,A5: set @ A] :
      ( ( ~ ( member @ A @ C2 @ B4 )
       => ( member @ A @ C2 @ A5 ) )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% UnCI
thf(fact_227_Un__iff,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) )
      = ( ( member @ A @ C2 @ A5 )
        | ( member @ A @ C2 @ B4 ) ) ) ).

% Un_iff
thf(fact_228_Un__empty,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( ( sup_sup @ ( set @ A ) @ A5 @ B4 )
        = ( bot_bot @ ( set @ A ) ) )
      = ( ( A5
          = ( bot_bot @ ( set @ A ) ) )
        & ( B4
          = ( bot_bot @ ( set @ A ) ) ) ) ) ).

% Un_empty
thf(fact_229_Un__insert__right,axiom,
    ! [A: $tType,A5: set @ A,A4: A,B4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ ( insert @ A @ A4 @ B4 ) )
      = ( insert @ A @ A4 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% Un_insert_right
thf(fact_230_Un__insert__left,axiom,
    ! [A: $tType,A4: A,B4: set @ A,C4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( insert @ A @ A4 @ B4 ) @ C4 )
      = ( insert @ A @ A4 @ ( sup_sup @ ( set @ A ) @ B4 @ C4 ) ) ) ).

% Un_insert_left
thf(fact_231_Un__Diff__cancel,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ ( minus_minus @ ( set @ A ) @ B4 @ A5 ) )
      = ( sup_sup @ ( set @ A ) @ A5 @ B4 ) ) ).

% Un_Diff_cancel
thf(fact_232_Un__Diff__cancel2,axiom,
    ! [A: $tType,B4: set @ A,A5: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ B4 @ A5 ) @ A5 )
      = ( sup_sup @ ( set @ A ) @ B4 @ A5 ) ) ).

% Un_Diff_cancel2
thf(fact_233_vimage__Un,axiom,
    ! [A: $tType,B: $tType,F: A > B,A5: set @ B,B4: set @ B] :
      ( ( vimage @ A @ B @ F @ ( sup_sup @ ( set @ B ) @ A5 @ B4 ) )
      = ( sup_sup @ ( set @ A ) @ ( vimage @ A @ B @ F @ A5 ) @ ( vimage @ A @ B @ F @ B4 ) ) ) ).

% vimage_Un
thf(fact_234_Un__empty__right,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ ( bot_bot @ ( set @ A ) ) )
      = A5 ) ).

% Un_empty_right
thf(fact_235_Un__empty__left,axiom,
    ! [A: $tType,B4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( bot_bot @ ( set @ A ) ) @ B4 )
      = B4 ) ).

% Un_empty_left
thf(fact_236_insert__is__Un,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [A11: A] : ( sup_sup @ ( set @ A ) @ ( insert @ A @ A11 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ).

% insert_is_Un
thf(fact_237_Un__singleton__iff,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,X5: A] :
      ( ( ( sup_sup @ ( set @ A ) @ A5 @ B4 )
        = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
      = ( ( ( A5
            = ( bot_bot @ ( set @ A ) ) )
          & ( B4
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A5
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B4
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A5
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B4
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% Un_singleton_iff
thf(fact_238_singleton__Un__iff,axiom,
    ! [A: $tType,X5: A,A5: set @ A,B4: set @ A] :
      ( ( ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) )
        = ( sup_sup @ ( set @ A ) @ A5 @ B4 ) )
      = ( ( ( A5
            = ( bot_bot @ ( set @ A ) ) )
          & ( B4
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) )
        | ( ( A5
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B4
            = ( bot_bot @ ( set @ A ) ) ) )
        | ( ( A5
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) )
          & ( B4
            = ( insert @ A @ X5 @ ( bot_bot @ ( set @ A ) ) ) ) ) ) ) ).

% singleton_Un_iff
thf(fact_239_Un__UNIV__left,axiom,
    ! [A: $tType,B4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( top_top @ ( set @ A ) ) @ B4 )
      = ( top_top @ ( set @ A ) ) ) ).

% Un_UNIV_left
thf(fact_240_Un__UNIV__right,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ ( top_top @ ( set @ A ) ) )
      = ( top_top @ ( set @ A ) ) ) ).

% Un_UNIV_right
thf(fact_241_UnE,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) )
     => ( ~ ( member @ A @ C2 @ A5 )
       => ( member @ A @ C2 @ B4 ) ) ) ).

% UnE
thf(fact_242_UnI1,axiom,
    ! [A: $tType,C2: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C2 @ A5 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% UnI1
thf(fact_243_UnI2,axiom,
    ! [A: $tType,C2: A,B4: set @ A,A5: set @ A] :
      ( ( member @ A @ C2 @ B4 )
     => ( member @ A @ C2 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% UnI2
thf(fact_244_bex__Un,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,P: A > $o] :
      ( ( ? [X: A] :
            ( ( member @ A @ X @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) )
            & ( P @ X ) ) )
      = ( ? [X: A] :
            ( ( member @ A @ X @ A5 )
            & ( P @ X ) )
        | ? [X: A] :
            ( ( member @ A @ X @ B4 )
            & ( P @ X ) ) ) ) ).

% bex_Un
thf(fact_245_ball__Un,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,P: A > $o] :
      ( ( ! [X: A] :
            ( ( member @ A @ X @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) )
           => ( P @ X ) ) )
      = ( ! [X: A] :
            ( ( member @ A @ X @ A5 )
           => ( P @ X ) )
        & ! [X: A] :
            ( ( member @ A @ X @ B4 )
           => ( P @ X ) ) ) ) ).

% ball_Un
thf(fact_246_Un__assoc,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) @ C4 )
      = ( sup_sup @ ( set @ A ) @ A5 @ ( sup_sup @ ( set @ A ) @ B4 @ C4 ) ) ) ).

% Un_assoc
thf(fact_247_Un__absorb,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ A5 )
      = A5 ) ).

% Un_absorb
thf(fact_248_Un__commute,axiom,
    ! [A: $tType] :
      ( ( sup_sup @ ( set @ A ) )
      = ( ^ [A10: set @ A,B9: set @ A] : ( sup_sup @ ( set @ A ) @ B9 @ A10 ) ) ) ).

% Un_commute
thf(fact_249_Un__left__absorb,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) )
      = ( sup_sup @ ( set @ A ) @ A5 @ B4 ) ) ).

% Un_left_absorb
thf(fact_250_Un__left__commute,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C4: set @ A] :
      ( ( sup_sup @ ( set @ A ) @ A5 @ ( sup_sup @ ( set @ A ) @ B4 @ C4 ) )
      = ( sup_sup @ ( set @ A ) @ B4 @ ( sup_sup @ ( set @ A ) @ A5 @ C4 ) ) ) ).

% Un_left_commute
thf(fact_251_Un__Diff,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C4: set @ A] :
      ( ( minus_minus @ ( set @ A ) @ ( sup_sup @ ( set @ A ) @ A5 @ B4 ) @ C4 )
      = ( sup_sup @ ( set @ A ) @ ( minus_minus @ ( set @ A ) @ A5 @ C4 ) @ ( minus_minus @ ( set @ A ) @ B4 @ C4 ) ) ) ).

% Un_Diff
thf(fact_252_vimage__insert,axiom,
    ! [A: $tType,B: $tType,F: A > B,A4: B,B4: set @ B] :
      ( ( vimage @ A @ B @ F @ ( insert @ B @ A4 @ B4 ) )
      = ( sup_sup @ ( set @ A ) @ ( vimage @ A @ B @ F @ ( insert @ B @ A4 @ ( bot_bot @ ( set @ B ) ) ) ) @ ( vimage @ A @ B @ F @ B4 ) ) ) ).

% vimage_insert
thf(fact_253_sup__top__right,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_top @ A @ ( type2 @ A ) )
     => ! [X5: A] :
          ( ( sup_sup @ A @ X5 @ ( top_top @ A ) )
          = ( top_top @ A ) ) ) ).

% sup_top_right
thf(fact_254_sup__top__left,axiom,
    ! [A: $tType] :
      ( ( bounded_lattice_top @ A @ ( type2 @ A ) )
     => ! [X5: A] :
          ( ( sup_sup @ A @ ( top_top @ A ) @ X5 )
          = ( top_top @ A ) ) ) ).

% sup_top_left
thf(fact_255_subtr2__trans__Un,axiom,
    ! [Ns122: set @ n,Tr1: dtree,Tr22: dtree,Ns23: set @ n,Tr3: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns122 @ Tr1 @ Tr22 )
     => ( ( gram_L1283001940subtr2 @ Ns23 @ Tr22 @ Tr3 )
       => ( gram_L1283001940subtr2 @ ( sup_sup @ ( set @ n ) @ Ns122 @ Ns23 ) @ Tr1 @ Tr3 ) ) ) ).

% subtr2_trans_Un

%----Type constructors (12)
thf(tcon_HOL_Obool___Lattices_Obounded__lattice,axiom,
    bounded_lattice @ $o @ ( type2 @ $o ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice_1,axiom,
    ! [A8: $tType] : ( bounded_lattice @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice_2,axiom,
    ! [A8: $tType,A13: $tType] :
      ( ( bounded_lattice @ A13 @ ( type2 @ A13 ) )
     => ( bounded_lattice @ ( A8 > A13 ) @ ( type2 @ ( A8 > A13 ) ) ) ) ).

thf(tcon_fun___Lattices_Obounded__lattice__top,axiom,
    ! [A8: $tType,A13: $tType] :
      ( ( bounded_lattice @ A13 @ ( type2 @ A13 ) )
     => ( bounded_lattice_top @ ( A8 > A13 ) @ ( type2 @ ( A8 > A13 ) ) ) ) ).

thf(tcon_fun___Orderings_Otop,axiom,
    ! [A8: $tType,A13: $tType] :
      ( ( top @ A13 @ ( type2 @ A13 ) )
     => ( top @ ( A8 > A13 ) @ ( type2 @ ( A8 > A13 ) ) ) ) ).

thf(tcon_fun___Orderings_Obot,axiom,
    ! [A8: $tType,A13: $tType] :
      ( ( bot @ A13 @ ( type2 @ A13 ) )
     => ( bot @ ( A8 > A13 ) @ ( type2 @ ( A8 > A13 ) ) ) ) ).

thf(tcon_Set_Oset___Lattices_Obounded__lattice__top_3,axiom,
    ! [A8: $tType] : ( bounded_lattice_top @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Otop_4,axiom,
    ! [A8: $tType] : ( top @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Obot_5,axiom,
    ! [A8: $tType] : ( bot @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Lattices_Obounded__lattice__top_6,axiom,
    bounded_lattice_top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Otop_7,axiom,
    top @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Obot_8,axiom,
    bot @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X5: A,Y: A] :
      ( ( if @ A @ $false @ X5 @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X5: A,Y: A] :
      ( ( if @ A @ $true @ X5 @ Y )
      = X5 ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    gram_L864798063lle_wf @ ( gram_L1004374585hsubst @ tr2 @ tr2 ) ).

%------------------------------------------------------------------------------
